#include <Adafruit_NeoPixel.h>
#include "WS2812_Definitions.h"
#include <stdlib.h>

#define PIN 13
#define LED_COUNT 24


Adafruit_NeoPixel leds = Adafruit_NeoPixel(LED_COUNT, PIN, NEO_GRB + NEO_KHZ800);

unsigned long previousMillis = 0;
const long interval = 100; 
int modeSetting = 0;
boolean buttonState = 1;
boolean modeChanged = 0;
int rainbowCycle = 0;

void setup()
{
  Serial.begin(9600);
  leds.begin();
  clearLEDs();   // This function, defined below, turns all LEDs off...
  leds.show();
  pinMode(3, INPUT);// ...but the LEDs don't actually update until you call this.
}

void loop()
{
  unsigned long currentMillis = millis();
  Serial.print("modeSetting:");
  Serial.print(modeSetting);
  Serial.print("   modeChanged:");
  Serial.println(modeChanged);
  checkButton();
  
  if(modeSetting == 0){
    if (currentMillis - previousMillis >= interval) {
      previousMillis = currentMillis;
      if(rainbowCycle<LED_COUNT){ 
        rainbowCycle++;
        rainbow(rainbowCycle);
      }else{
        rainbowCycle = 0;
        rainbow(rainbowCycle);
      }
    }
  }

  if(modeSetting == 1){
    clearLEDs();
    for (int i=0; i<LED_COUNT; i++){
    leds.setPixelColor(i, 255, 0, 0);
    } 
    leds.show();
    checkButton();
  }

  if(modeSetting == 2){
    clearLEDs();
    for (int i=0; i<LED_COUNT; i++){
    leds.setPixelColor(i, 0, 255, 0);
    } 
    leds.show();
    checkButton();
  }

  if(modeSetting == 3){
    clearLEDs();
    for (int i=0; i<LED_COUNT; i++){
    leds.setPixelColor(i, 0, 0, 255);
    } 
    leds.show();
    checkButton();
  }
  if(modeSetting == 4){
    clearLEDs();
    for (int i=0; i<LED_COUNT; i++){
    leds.setPixelColor(i, 255, 255, 0);
    } 
    leds.show();
    checkButton();
  }

  if(modeSetting == 5){
    clearLEDs();
    for (int i=0; i<LED_COUNT; i++){
    leds.setPixelColor(i, 0, 255, 255);
    } 
    leds.show();
    checkButton();
  }

  if(modeSetting == 6){
    clearLEDs();
    for (int i=0; i<LED_COUNT; i++){
    leds.setPixelColor(i, 255, 0, 255);
    } 
    leds.show();
    checkButton();
  }

  if(modeSetting == 7){
    clearLEDs();
    for (int i=0; i<LED_COUNT; i++){
    leds.setPixelColor(i, 255, 255, 255);
    } 
    leds.show();
    checkButton();
  }

  
}

void clearLEDs()
{
  for (int i=0; i<LED_COUNT; i++)
  {
    leds.setPixelColor(i, 0);
  }
}


void rainbow(byte startPosition) 
{
  int rainbowScale = 192 / LED_COUNT;
  
  for (int i=0; i<LED_COUNT; i++){
    leds.setPixelColor(i, rainbowOrder((rainbowScale * (i + startPosition)) % 192));
  }
  leds.show();
}

void checkButton(){
  buttonState = digitalRead(3);
  if(buttonState == LOW && modeChanged == 0){
    modeChanged = 1;
    if(modeSetting < 7){
      modeSetting++;
    }else{
      modeSetting = 0;
    }
  }else{
    if(buttonState == HIGH){
    modeChanged = 0;
  }
  }
}

uint32_t rainbowOrder(byte position) 
{
  // 6 total zones of color change:
  if (position < 31)  // Red -> Yellow (Red = FF, blue = 0, green goes 00-FF)
  {
    return leds.Color(0xFF, position * 8, 0);
  }
  else if (position < 63)  // Yellow -> Green (Green = FF, blue = 0, red goes FF->00)
  {
    position -= 31;
    return leds.Color(0xFF - position * 8, 0xFF, 0);
  }
  else if (position < 95)  // Green->Aqua (Green = FF, red = 0, blue goes 00->FF)
  {
    position -= 63;
    return leds.Color(0, 0xFF, position * 8);
  }
  else if (position < 127)  // Aqua->Blue (Blue = FF, red = 0, green goes FF->00)
  {
    position -= 95;
    return leds.Color(0, 0xFF - position * 8, 0xFF);
  }
  else if (position < 159)  // Blue->Fuchsia (Blue = FF, green = 0, red goes 00->FF)
  {
    position -= 127;
    return leds.Color(position * 8, 0, 0xFF);
  }
  else  //160 <position< 191   Fuchsia->Red (Red = FF, green = 0, blue goes FF->00)
  {
    position -= 159;
    return leds.Color(0xFF, 0x00, 0xFF - position * 8);
  }
}
